/* Copyright (C) 2015-2018 RealVNC Ltd.  All Rights Reserved.
 */

#include <vnccommon/Mutex.h>

using namespace vnccommon;

MutexException::MutexException(const std::string& message)
        :   mMessage(std::string("MutexException: ") + message)
{
}

const char* MutexException::what() const throw()
{
    return mMessage.c_str();
}

MutexException::~MutexException() throw()
{
}

Mutex::Locker::Locker(Mutex& mutex)
        :   mMutex(mutex)
{
    mMutex.internalLock();
}

Mutex::Locker::~Locker()
{
    mMutex.internalUnlock();
}

InternalMutexType& Mutex::internalGet()
{
    return mMutex;
}

